/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class BaseElectricTileEntity
extends SmartTileEntity {
    protected final InternalEnergyStorage localEnergy;
    protected LazyOptional<IEnergyStorage> lazyEnergy;
    private boolean firstTickState = true;
    protected final int CAPACITY;
    protected final int MAX_IN;
    protected final int MAX_OUT;
    private LazyOptional<IEnergyStorage> escacheUp = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheDown = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheNorth = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheEast = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheSouth = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheWest = LazyOptional.empty();

    public BaseElectricTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state, int CAPACITY, int MAX_IN, int MAX_OUT) {
        super(tileEntityTypeIn, pos, state);
        this.localEnergy = new InternalEnergyStorage(CAPACITY, MAX_IN, MAX_OUT);
        this.CAPACITY = CAPACITY;
        this.MAX_IN = MAX_IN;
        this.MAX_OUT = MAX_OUT;
        this.lazyEnergy = LazyOptional.of(() -> this.localEnergy);
        this.setLazyTickRate(20);
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (this.isEnergyInput(side) || this.isEnergyOutput(side))) {
            return this.lazyEnergy.cast();
        }
        return super.getCapability(cap, side);
    }

    public abstract boolean isEnergyInput(Direction var1);

    public abstract boolean isEnergyOutput(Direction var1);

    protected void read(CompoundTag compound, boolean arg1) {
        super.read(compound, arg1);
        this.localEnergy.read(compound);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.localEnergy.write(compound);
    }

    public void remove() {
        this.lazyEnergy.invalidate();
    }

    @Deprecated
    public void outputTick(int max) {
        for (Direction side : Direction.values()) {
            if (!this.isEnergyOutput(side)) continue;
            this.localEnergy.outputToSide(this.f_58857_, this.f_58858_, side, max);
        }
    }

    public void tick() {
        super.tick();
        if (this.firstTickState) {
            this.firstTickState = false;
            this.firstTick();
        }
    }

    public void firstTick() {
        this.updateCache();
    }

    public boolean ignoreCapSide() {
        return false;
    }

    public void updateCache() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        for (Direction side : Direction.values()) {
            this.updateCache(side);
        }
    }

    public void updateCache(Direction side) {
        if (!this.f_58857_.m_46749_(this.f_58858_.m_142300_(side))) {
            this.setCache(side, (LazyOptional<IEnergyStorage>)LazyOptional.empty());
            return;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(side));
        if (te == null) {
            this.setCache(side, (LazyOptional<IEnergyStorage>)LazyOptional.empty());
            return;
        }
        LazyOptional le = te.getCapability(CapabilityEnergy.ENERGY, side.m_122424_());
        if (this.ignoreCapSide() && !le.isPresent()) {
            le = te.getCapability(CapabilityEnergy.ENERGY);
        }
        if (le.equals(this.getCachedEnergy(side))) {
            return;
        }
        this.setCache(side, (LazyOptional<IEnergyStorage>)le);
        le.addListener(es -> this.updateCache(side));
    }

    public void setCache(Direction side, LazyOptional<IEnergyStorage> storage) {
        switch (side) {
            case DOWN: {
                this.escacheDown = storage;
                break;
            }
            case EAST: {
                this.escacheEast = storage;
                break;
            }
            case NORTH: {
                this.escacheNorth = storage;
                break;
            }
            case SOUTH: {
                this.escacheSouth = storage;
                break;
            }
            case UP: {
                this.escacheUp = storage;
                break;
            }
            case WEST: {
                this.escacheWest = storage;
            }
        }
    }

    public LazyOptional<IEnergyStorage> getCachedEnergy(Direction side) {
        switch (side) {
            case DOWN: {
                return this.escacheDown;
            }
            case EAST: {
                return this.escacheEast;
            }
            case NORTH: {
                return this.escacheNorth;
            }
            case SOUTH: {
                return this.escacheSouth;
            }
            case UP: {
                return this.escacheUp;
            }
            case WEST: {
                return this.escacheWest;
            }
        }
        return LazyOptional.empty();
    }

    public boolean isValidUpgradeSide(BlockState state, Direction side) {
        return false;
    }

    public float getBoostPerUpgrade() {
        return 0.0f;
    }
}

